#include <amxmod> 
#include <amxmisc>
#include <string>
#include <float>
#include <Vexd_Utilities>

new beam, boom

public vexd_pfntouch(pToucher, pTouched) {
	new szClassName[32]
	Entvars_Get_String(pToucher, EV_SZ_classname, szClassName, 32);

	if(equal(szClassName, "vexd_rocket")) {
		emit_sound(pToucher, CHAN_WEAPON, "vox/_period.wav", 1.0, ATTN_NORM, 0, PITCH_NORM) 
		emit_sound(pToucher, CHAN_VOICE, "vox/_period.wav", 1.0, ATTN_NORM, 0, PITCH_NORM) 

		new Float:vExplodeAt[3]
		Entvars_Get_Vector(pToucher, EV_VEC_origin, vExplodeAt)

		RadiusDamage(vExplodeAt, 1)

		message_begin(MSG_BROADCAST, SVC_TEMPENTITY)
		write_byte(3)
		write_coord(floatround(vExplodeAt[0]))
		write_coord(floatround(vExplodeAt[1]))
		write_coord(floatround(vExplodeAt[2]))
		write_short(boom)
		write_byte(50)
		write_byte(15)
		write_byte(0)
		message_end()

		new iOwner
		iOwner = Entvars_Get_Edict(pToucher, EV_ENT_owner)

		AttachView(iOwner, iOwner)	//Resets rocket owner's view (in case of vrocket).

		RemoveEntity(pToucher)
	}

	return 1;
}

public Vexd_CreateRocket(id,level,cid){ 
	if (!cmd_access(id,level,cid,1)) 
		return PLUGIN_HANDLED

	new Float:vOrigin[3]
	new Float:vAngles[3]
	Entvars_Get_Vector(id, EV_VEC_origin, vOrigin)
	Entvars_Get_Vector(id, EV_VEC_v_angle, vAngles)

        new NewEnt
        NewEnt = CreateEntity("info_target")

        if(NewEnt == 0) {
            return PLUGIN_HANDLED_MAIN
        }

	Entvars_Set_String(NewEnt, EV_SZ_classname, "vexd_rocket")

        ENT_SetModel(NewEnt, "models/rpgrocket.mdl")

	new Float:MinBox[3]
	new Float:MaxBox[3]
	MinBox[0] = -1.0
	MinBox[1] = -1.0
	MinBox[2] = -1.0
	MaxBox[0] = 1.0
	MaxBox[1] = 1.0
	MaxBox[2] = 1.0

	Entvars_Set_Vector(NewEnt, EV_VEC_mins, MinBox)
	Entvars_Set_Vector(NewEnt, EV_VEC_maxs, MaxBox)

	ENT_SetOrigin(NewEnt, vOrigin)
	Entvars_Set_Vector(NewEnt, EV_VEC_angles, vAngles)

	Entvars_Set_Int(NewEnt, EV_INT_effects, 64)  //64 = EF_LIGHT, rocket glow. 64??
	Entvars_Set_Int(NewEnt, EV_INT_solid, 2)    //2 = Solid bbox. (const.h)
	Entvars_Set_Int(NewEnt, EV_INT_movetype, 5) //5 = movetype_fly, No grav, but collides.
	Entvars_Set_Edict(NewEnt, EV_ENT_owner, id)


	new Float:fNewVelocity[3] 
	VelocityByAim(id, 400, fNewVelocity)
	Entvars_Set_Vector(NewEnt, EV_VEC_velocity, fNewVelocity)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
	write_byte(22) 
	write_short(NewEnt) 
	write_short(beam) 
	write_byte(45) 
	write_byte(4) 
	write_byte(255) 
	write_byte(0) 
	write_byte(0) 
	write_byte(128)
	message_end() 

	emit_sound(NewEnt, CHAN_WEAPON, "weapons/rocketfire1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	emit_sound(NewEnt, CHAN_VOICE, "weapons/rocket1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	return PLUGIN_HANDLED_MAIN
}

public Vexd_CreateVRocket(id,level,cid){ 
	if (!cmd_access(id,level,cid,1)) 
		return PLUGIN_HANDLED

	new Float:vOrigin[3]
	new Float:vAngles[3]
	Entvars_Get_Vector(id, EV_VEC_origin, vOrigin)
	Entvars_Get_Vector(id, EV_VEC_v_angle, vAngles)

        new NewEnt
        NewEnt = CreateEntity("info_target")

        if(NewEnt == 0) {
            return PLUGIN_HANDLED_MAIN
        }

	Entvars_Set_String(NewEnt, EV_SZ_classname, "vexd_rocket")

        ENT_SetModel(NewEnt, "models/rpgrocket.mdl")

	new Float:MinBox[3]
	new Float:MaxBox[3]

	MinBox[0] = -1.0
	MinBox[1] = -1.0
	MinBox[2] = -1.0
	MaxBox[0] = 1.0
	MaxBox[1] = 1.0
	MaxBox[2] = 1.0

	Entvars_Set_Vector(NewEnt, EV_VEC_mins, MinBox)
	Entvars_Set_Vector(NewEnt, EV_VEC_maxs, MaxBox)

	ENT_SetOrigin(NewEnt, vOrigin)
	Entvars_Set_Vector(NewEnt, EV_VEC_angles, vAngles)

	Entvars_Set_Int(NewEnt, EV_INT_effects, 1)  //1 = EF_LIGHT, rocket glow. 64??
	Entvars_Set_Int(NewEnt, EV_INT_solid, 2)    //2 = Solid bbox. (const.h)
	Entvars_Set_Int(NewEnt, EV_INT_movetype, 5) //5 = movetype_fly, No grav, but collides.
	Entvars_Set_Edict(NewEnt, EV_ENT_owner, id)


	new Float:fNewVelocity[3] 
	VelocityByAim(id, 400, fNewVelocity)
	Entvars_Set_Vector(NewEnt, EV_VEC_velocity, fNewVelocity)

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY) 
	write_byte(22) 
	write_short(NewEnt) 
	write_short(beam) 
	write_byte(45) 
	write_byte(4) 
	write_byte(255) 
	write_byte(0) 
	write_byte(0) 
	write_byte(128)
	message_end() 

	emit_sound(NewEnt, CHAN_WEAPON, "weapons/rocketfire1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)
	emit_sound(NewEnt, CHAN_VOICE, "weapons/rocket1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM)

	AttachView(id, NewEnt)

	return PLUGIN_HANDLED_MAIN
}

public plugin_init(){ 
    register_plugin("Vexd Entity demo (Rocket)","1.00","default") 
    register_concmd("amx_rocket","Vexd_CreateRocket",ADMIN_KICK)
    register_concmd("amx_vrocket","Vexd_CreateVRocket",ADMIN_KICK)

    return PLUGIN_CONTINUE 
}

public plugin_precache() {
	precache_sound("vox/_period.wav")
	precache_sound("weapons/rocketfire1.wav") 
	precache_sound("weapons/rocket1.wav") 
	precache_model("models/rpgrocket.mdl")
	beam = precache_model("sprites/laserbeam.spr")
	boom = precache_model("sprites/zerogxplode.spr")

	return PLUGIN_CONTINUE 
}